<?php
/**
 * GDF Redux
 *
 * Handles Rudux plugin and extra actions
 *
 * @author   AyeCode
 * @package  GDF/Core
 * @since    2.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GDF_Admin_Redux {

	/**
	 * Setup class.
	 *
	 * @since 2.0.0
	 */
	public function __construct() {

		// actions
		add_action( 'redux/construct', array(__CLASS__, 'maybe_run_compiler'), 10, 1 );


		// filters
		add_filter( 'redux/field/gdf/output_css', array(__CLASS__, 'maybe_compile_css'), 10, 1 );
	}

	/**
	 * If there GDF version is updated then run the complier so our css is good to go.
	 *
	 * @param $all
	 *
	 * @return mixed
	 */
	public static function maybe_run_compiler($all){
		/* Get the old database version. */
		$old_db_version = get_option( 'gdf_db_version' );
		if ( empty( $old_db_version ) ){ $old_db_version =1;}

		// if updated version, run the compiler.
		if (  $old_db_version  < GDF_VERSION  ){
			$all->run_compiler = true;
			$tr = get_option( 'gdf-transients', array() );
			$tr['run_compiler']   = 1;
			$tr['last_save_mode'] = "defaults";
			update_option('gdf-transients',$tr);

		}

		return $all;
	}


	/**
	 * Only compile the CSS if its different from the defaults.
	 * 
	 * @param $field
	 *
	 * @return mixed
	 */
	public static function maybe_compile_css($field){
		global	$gdf;
		if($field['compiler']==''){return $field;}

		if($field['id']=='home_top_widget'){$field['compiler']='';}
		if($field['id']=='home_site_width'){$field['compiler']='';}
		if($field['id']=='body-background-gradient'){$field['compiler']='';}
		if($field['id']=='footer-background-gradient'){$field['compiler']='';}
		if($field['id']=='head-background-gradient'){$field['compiler']='';}
		if($field['id']=='head-menu-background-gradient'){$field['compiler']='';}
		if($field['id']=='head-menu-radius'){$field['compiler']='';}

		if($field['type']=='spacing'){
			if($gdf[$field['id']] == $field['default'] ){$field['compiler']='';}
		}elseif($field['type']=='typography'){
			$changed = false;
			if($gdf[$field['id']]['font-family'] != $field['default']['font-family']){$changed = true;}
			if($gdf[$field['id']]['font-weight'] != $field['default']['font-weight']){$changed = true;}
			if($gdf[$field['id']]['font-size'] != $field['default']['font-size']){$changed = true;}
			if($gdf[$field['id']]['line-height'] != $field['default']['line-height']){$changed = true;}
			if($gdf[$field['id']]['color'] != $field['default']['color']){$changed = true;}

			if(!$changed){$field['compiler']='';}

		}elseif($field['type']=='background'){
			$changed = false;
			if(isset($gdf[$field['id']]['background-color']) && $gdf[$field['id']]['background-color'] != $field['default']['background-color'] ){$changed = true;}
			if(isset($gdf[$field['id']]['background-repeat']) && $gdf[$field['id']]['background-repeat'] !=''){$changed = true;}
			if(isset($gdf[$field['id']]['background-size']) && $gdf[$field['id']]['background-size'] !=''){$changed = true;}
			if(isset($gdf[$field['id']]['background-attachment']) && $gdf[$field['id']]['background-attachment'] !=''){$changed = true;}
			if(isset($gdf[$field['id']]['background-position']) && $gdf[$field['id']]['background-position'] !=''){$changed = true;}
			if(isset($gdf[$field['id']]['background-image']) && $gdf[$field['id']]['background-image'] !=''){$changed = true;}

			if(!$changed){$field['compiler']='';}
		}elseif($field['type']=='color'){
			if($gdf[$field['id']] == $field['default'] ){$field['compiler']='';}
		}elseif($field['type']=='border'){
			sort($gdf[$field['id']]);sort($field['default']);
			if($gdf[$field['id']] == $field['default'] ){$field['compiler']='';}
		}elseif($field['type']=='link_color'){
			if($gdf[$field['id']] == $field['default'] ){$field['compiler']='';}
		}
		elseif($field['type']=='switch'){$field['compiler']='';}

		return $field;
	}


	
	

}
new GDF_Admin_Redux();